<?php
/**
 * Enqueue script and styles for child theme
 */
function woodmart_child_enqueue_styles() {
	wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'woodmart-style' ), woodmart_get_theme_info( 'Version' ) );
}
add_action( 'wp_enqueue_scripts', 'woodmart_child_enqueue_styles', 10010 );
add_action('wp_footer', 'custom_update_price_based_on_options');

function custom_update_price_based_on_options() {
    if( is_product() ) {
    ?>
    <script type="text/javascript">
    jQuery(document).ready(function($) {
        // Dinleme için eklenti sınıflarını izleyin
        $('body').on('change', '.yith_wcepo_option, .yith_wcepo_options', function() {
            // Ek fiyatı güncelle
            var extra_price = 0;

            // YITH seçeneklerinin fiyatlarını topla
            $('.yith_wcepo_options input:checked').each(function() {
                var price = $(this).data('price'); // Fiyatı al
                if (price) {
                    extra_price += parseFloat(price);
                }
            });

            // WooCommerce orijinal ürün fiyatını al
            var original_price = parseFloat($('.woocommerce-Price-amount bdi').text().replace(/[^0-9\.]/g, ''));

            // Toplam fiyatı hesapla ve ekrana yazdır
            var total_price = original_price + extra_price;
            $('.woocommerce-Price-amount bdi').text(total_price.toFixed(2)); // Güncellenen fiyatı göster
        });
    });
    </script>
    <?php
    }
}
