<?php
/**
 * Plugin Name: Category Price Updater
 * Description: Allows adding a specific amount to all products in a selected category.
 * Version: 1.0
 * Author: Your Name
 */

// Ayar sayfası ekle
add_action('admin_menu', function() {
    add_menu_page(
        'Category Price Updater',
        'Price Updater',
        'manage_options',
        'category-price-updater',
        'category_price_updater_page'
    );
});

// Ayar sayfası içeriği
function category_price_updater_page() {
    ?>
    <div class="wrap">
        <h1>Category Price Updater</h1>
        <form method="post" action="">
            <?php
            // CSRF güvenliği
            wp_nonce_field('category_price_updater', 'category_price_updater_nonce');

            // Ürün kategorilerini al
            $categories = get_terms(['taxonomy' => 'product_cat', 'hide_empty' => false]);
            ?>
            <label for="category">Select Category:</label>
            <select name="category" id="category" required>
                <?php foreach ($categories as $category) : ?>
                    <option value="<?php echo esc_attr($category->term_id); ?>">
                        <?php echo esc_html($category->name); ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <br><br>
            <label for="amount">Amount to Add (₺):</label>
            <input type="number" name="amount" id="amount" step="0.01" required>
            <br><br>
            <input type="submit" name="update_prices" value="Update Prices" class="button button-primary">
        </form>
    </div>
    <?php
}

// Fiyat güncelleme işlemi admin_init bağlamında
add_action('admin_init', function() {
    if (isset($_POST['update_prices']) && check_admin_referer('category_price_updater', 'category_price_updater_nonce')) {
        $category_id = intval($_POST['category']);
        $amount = floatval($_POST['amount']);

        // Kategoriye bağlı ürünleri al
        $args = [
            'post_type' => 'product',
            'posts_per_page' => -1,
            'tax_query' => [
                [
                    'taxonomy' => 'product_cat',
                    'field'    => 'term_id',
                    'terms'    => $category_id,
                ],
            ],
        ];
        $products = get_posts($args);

        // Ürün fiyatlarını güncelle
        foreach ($products as $product) {
            $product_id = $product->ID;
            $price = get_post_meta($product_id, '_price', true);

            if ($price !== '') {
                $new_price = $price + $amount;
                update_post_meta($product_id, '_price', $new_price);

                // Düzenli fiyatı (Regular Price) de güncelle
                $regular_price = get_post_meta($product_id, '_regular_price', true);
                if ($regular_price !== '') {
                    update_post_meta($product_id, '_regular_price', $regular_price + $amount);
                }
            }
        }

        // Bilgilendirme mesajı
        add_action('admin_notices', function() use ($category_id, $amount) {
            $category = get_term($category_id);
            printf('<div class="notice notice-success is-dismissible"><p>Added ₺%s to all products in the "%s" category.</p></div>', number_format_i18n($amount, 2), esc_html($category->name));
        });
    }
});
